// auditLogger.mjs
import pkg from 'pg';

const { Pool } = pkg;

export const pool = new Pool({
  host: "localhost",
  port: 5432,
  user: "postgres",
  password: "manoj@123",
  database: "postgres",
});

pool.on('error', (err) => {
  console.error('Unexpected error on idle pg client', err);
});

export async function logAudit(
  username,
  action_type,
  table_name,
  record_id,
  field_name = null,
  old_value = null,
  new_value = null,
  details = null
) {
 
  const SCHEMA = "exelon_lms";
  const timestamp = new Date().toISOString();

  const sql = `
    INSERT INTO ${SCHEMA}.audit_logs
    (timestamp, username, action_type, table_name, record_id, field_name, old_value, new_value, details)
    VALUES
    ($1, $2, $3, $4, $5, $6, $7, $8, $9)
    RETURNING id;
  `;

  const values = [
    timestamp,
    username,
    action_type,
    table_name,
    record_id,
    field_name,
    old_value,
    new_value,
    details
  ];

  try {
    const res = await pool.query(sql, values);
    const insertedId = res.rows[0] ? res.rows[0].id : null;
    console.log(`Audit logged: ${action_type} on ${table_name} by ${username} — audit_id: ${insertedId}`);
    return insertedId;
  } catch (err) {
    console.error("Error logging audit:", err.message);
    return null;
  }
}

export async function closePool() {
  try {
    await pool.end();
    console.log("Postgres pool closed");
  } catch (err) {
    console.error("Error closing pool:", err);
  }
}
